/**
 * Created by lei.wang_1 on 2016/11/18.
 */
appModule.directive("replyList", ["notices", "api", "utils", "$translate",'log', function (notices, api, utils, translate,log) {
    return {
        template: `<div class="replyListContent">
                        <scroll-container>
                            <table class="listContainer">
                                <tr class="tHead">
                                    <th translate="task.info.order-number" class="serialNumber"></th>
                                    <th translate="task.info.replier" class="replierName"></th>
                                    <th ng-repeat="subTask in task.ext_data.sub_task_list" ng-bind="subTask.title" class="item {{subTask.type}}"></th>
                                    <th translate="task.audit.reply-time" class="replyTime"></th>
                                    <th>&nbsp;</th>
                                </tr>
                                <tr ng-repeat="reply in task.replies" class="subTaskItem">
                                    <td ng-bind="reply.serial_num" class="serialNumber"></td>
                                    <td class="replierName"><span ng-bind="reply.userName"  class="text-ellipsis"></span></td>
                                    <td ng-repeat="subTask in task.ext_data.sub_task_list" class="item {{subTask.type}}">
                                        <reply-item ng-if="reply.sub_reply_list[subTask.id] != undefined" item="reply.sub_reply_list[subTask.id]"></reply-item>
                                    </td>
                                    <td class="replyTime">
                                        <span ng-bind="getTimeText(reply.created_at)" ng-class="{'out-date':task.ext_data.end_time_stamp > 0 && reply.created_at > task.ext_data.end_time_stamp}"></span>
                                    </td>
                                    <td>&nbsp;</td>
                                </tr>
                             </table>
                         </scroll-container>
                     </div>`,
        restrict: "AE",
        replace: true,
        scope: {
            task: "="
        },
        link: function ($scope) {
            var PAGE_COUNT = 20;
            var stopWatch = $scope.$watch("task", function (newV) {
                if(!!newV){
                    $scope.task.replies = [];
                    $scope.getReplies(newV.id,{});
                }
            });
            $scope.getTimeText = function (timestamp) {
                return utils.time2str(timestamp / 1000);
            };
            $scope.getReplies = function (taskId, criteria) {
                criteria.count = PAGE_COUNT;
                api.getFeedbackList(taskId, criteria, function (data) {
                    utils.applyScope($scope, function () {
                        if (data.length > 0) {
                            var index = $scope.task.replies.length;
                            if(criteria.start_time > 0){
                                $scope.removeDuplicateReply(data);
                                $scope.task.replies = data.concat($scope.task.replies);
                                $scope.getReplierName(0, data);
                            }else{
                                $scope.task.replies = $scope.task.replies.concat(data);
                                $scope.getReplierName(index, data);
                            }
                        }
                    });
                }, function (msg, errorCode) {
                    log.logInfo("failed to load task " + taskId + "'s detail:" + msg);
                    api.notifyError(msg);
                });
            };

            $scope.getReplierName = function (startIndex, data) {
                data.forEach(function (item, index) {
                    notices.getBasicUserInfo(item.user_id, function (info) {
                        utils.applyScope($scope, function () {
                            var i = index + startIndex;
                            $scope.task.replies[i].userName = info.displayName;
                        });
                    });
                });
            };

            $scope.onScrollDown = function(){
                var endTime= $scope.task.replies[$scope.task.replies.length - 1].created_at;
                var criteria = {
                    end_time:endTime
                };
                $scope.getReplies($scope.task.id,criteria);
            };

            $scope.removeDuplicateReply = function(newReplies){
                var i, j;
                for(i=0;i<newReplies.length;i++){
                    for(j=0;j<$scope.task.replies.length;j++){
                        if($scope.task.replies[j].id == newReplies[i].id){
                            $scope.task.replies.splice(j,1);
                            break;
                        }
                    }
                }
            };

            var offDataUpdate = $scope.$on('dataUpdate',function(){
                var bbsId = $scope.task.id;
                if(bbsId){
                    if(!$scope.task.replies){
                        $scope.task.replies = [];
                    }
                    var startTime= $scope.task.replies[0] ? $scope.task.replies[0].created_at : 0;
                    var criteria = {
                        start_time:startTime
                    };
                    $scope.getReplies(bbsId,criteria);
                }
            });

            $scope.$on("$destroy", function () {
                stopWatch();
                offDataUpdate();
            });
        }
    };
}]);